dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."config.lua")
dofile(LockOn_Options.script_path.."sounds.lua")

local gettext = require("i_18n")
_ = gettext.translate

cursor_mode = 
{ 
    CUMODE_CLICKABLE = 0,
    CUMODE_CLICKABLE_AND_CAMERA  = 1,
    CUMODE_CAMERA = 2,
};

clickable_mode_initial_status  = cursor_mode.CUMODE_CLICKABLE

function default_button(hint_,device_,command_,arg_,arg_val_,arg_lim_)

	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}

	return  {	
				class 				= {class_type.BTN},
				hint  				= hint_,
				device 				= device_,
				action 				= {command_},
				stop_action 		= {command_},
				arg 				= {arg_},
				arg_value			= {arg_val_}, 
				arg_lim 			= {arg_lim_},
				use_release_message = {true}
			}
end

function default_1_position_tumb(hint_, device_, command_, arg_, arg_val_, arg_lim_)
	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}
	return  {	
				class 		= {class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {arg_val_}, 
				arg_lim   	= {arg_lim_},
				updatable 	= true, 
				use_OBB 	= true
			}
end

function default_2_position_tumb(hint_, device_, command_, arg_)
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {1,-1}, 
				arg_lim   	= {{0,1},{0,1}},
				updatable 	= true, 
				use_OBB 	= true
			}
end

function default_3_position_tumb(hint_,device_,command_,arg_,cycled_,inversed_)
	local cycled = true
	
	
	local val =  1
	if inversed_ then
	      val = -1
	end
	if cycled_ ~= nil then
	   cycled = cycled_
	end
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-val,val}, 
				arg_lim   	= {{-1,1},{-1,1}},
				updatable 	= true, 
				use_OBB 	= true,
				cycle       = cycled
			}
end

function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_,cycle_)
	
	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	local cycled  = cycle_ or false
	
	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {{0,1}},
				updatable 	= updatable, 
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative}, 
				cycle		= cycled			
			}
end

function default_movable_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)
	
	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	
	return  {	
				class 		= {class_type.MOVABLE_LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {{0,1}},
				updatable 	= updatable, 
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative}, 				
			}
end

function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)
	
	local relative = false
	local default = default_ or 0
	local updatable = updatable_ or false
	if relative_ ~= nil then
		relative = relative_
	end

	local gain = gain_ or 0.1
	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {arg_lim_},
				updatable 	= updatable, 
				use_OBB 	= false,
				gain		= {gain},
				relative    = {relative},  
				cycle		= false
			}
end


function multiposition_switch(hint_,device_,command_,arg_,count_,delta_,inversed_, min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5
	
	local inversed = 1
	if	inversed_ then
		inversed = -1
	end
	
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed}, 
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true, 
				use_OBB 	= true
			}
end

function multiposition_switch_limited(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5
	
	local inversed = 1
	if	inversed_ then
		inversed = -1
	end
	
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed}, 
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true, 
				use_OBB 	= true,
				cycle     	= false, 
			}
end

function default_button_axis(hint_, device_,command_1, command_2, arg_1, arg_2, limit_1, limit_2)
	local limit_1_   = limit_1 or 1.0
	local limit_2_   = limit_2 or 1.0
return {
			class		=	{class_type.BTN, class_type.LEV},
			hint		=	hint_,
			device		=	device_,
			action		=	{command_1, command_2},
			stop_action =   {command_1, 0},
			arg			=	{arg_1, arg_2},
			arg_value	= 	{1, 0.5},
			arg_lim		= 	{{0, limit_1_}, {0,limit_2_}},
			gain = {0, 0.1},
			relative	= 	{false, false},
			updatable 	= 	true, 
			use_OBB 	= 	true,
			use_release_message = {true, false},
			cycle 		= false
	}
end

function default_animated_lever(hint_, device_, command_, arg_, animation_speed_,arg_lim_,arg_value_)

local arg_lim = arg_lim_ or {0.0,1.0}
local arg_value = arg_value_ or 1.0
return  {	
	class  = {class_type.TUMB, class_type.TUMB},
	hint   	= hint_, 
	device 	= device_,
	action 	= {command_, command_},
	arg 		= {arg_, arg_},
	arg_value 	= {arg_value, -arg_value},
	arg_lim 	= {arg_lim, arg_lim},
	updatable  = true, 
	gain 		= {0.1, 0.1},
	animated 	= {true, true},
	animation_speed = {animation_speed_, animation_speed_}
}
end

function default_button_tumb(hint_, device_, command1_, command2_, arg_)
	return  {	
				class 		= {class_type.BTN,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command2_},
				stop_action = {command1_,0},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-1,1}, 
				arg_lim   	= {{-1,0},{0,1}},
				updatable 	= true, 
				use_OBB 	= true,
				use_release_message = {true,false}
			}
end
-- P-51D
elements = {}

--Right Swich Panel
elements["pnt_35"] = default_2_position_tumb(_("Generator Disconnect"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_3,35)
elements["pnt_35_1"] = default_1_position_tumb(_("Generator Connect") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_13,35,1,{1,1})
elements["pnt_35_0"] = default_1_position_tumb(_("Generator Disconnect") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_13,35,0,{0,0})

elements["MAGNETO1"] = default_2_position_tumb(_("Battery Disconnect"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_1,57)
elements["MAGNETO1_1"] = default_1_position_tumb(_("Battery Connect") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_12,57,1,{1,1})
elements["MAGNETO1_0"] = default_1_position_tumb(_("Battery Disconnect") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_12,57,0,{0,0})

elements["pnt_104"] = default_2_position_tumb(_("Gun Heating"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_19,104)
elements["pnt_104_1"] = default_1_position_tumb(_("Gun Heating On") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_26,104,1,{1,1})
elements["pnt_104_0"] = default_1_position_tumb(_("Gun Heating Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_26,104,0,{0,0})

elements["pnt_105"] = default_2_position_tumb(_("Pitot Heating"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_5,105)
elements["pnt_105_1"] = default_1_position_tumb(_("Pitot Heating On") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_14,105,1,{1,1})
elements["pnt_105_0"] = default_1_position_tumb(_("Pitot Heating Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_14,105,0,{0,0})

elements["Wing"]	= default_3_position_tumb(_("Wing Position Lights Bright/Off/Dim") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_8,512,false)
elements["Wing_1"] = default_1_position_tumb(_("Wing Position Lights Bright/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_15,512,1,{0,1})
elements["Wing_0"] = default_1_position_tumb(_("Wing Position Lights Dim/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_15,512,-1,{-1,0})

elements["Tail"]	= default_3_position_tumb(_("Tail Position Lights Bright/Off/Dim") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_9,513,false)
elements["Tail_1"] = default_1_position_tumb(_("Tail Position Lights Bright/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_16,513,1,{0,1})
elements["Tail_0"] = default_1_position_tumb(_("Tail Position Lights Dim/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_16,513,-1,{-1,0})

elements["pnt_108"]	= default_3_position_tumb(_("Red Recognition Light Key/Off/Steady") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_21,108,false, true)
elements["pnt_108_0"] = default_1_position_tumb(_("Red Recognition Light Steady/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_27,108,1,{0,1})
elements["pnt_108_1"] = default_1_position_tumb(_("Red Recognition Light Key/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_27,108,-1,{-1,0})

elements["pnt_109"]	= default_3_position_tumb(_("Green Recognition Light Key/Off/Steady") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_22,109,false, true)
elements["pnt_109_0"] = default_1_position_tumb(_("Green Recognition Light Steady/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_28,109,1,{0,1})
elements["pnt_109_1"] = default_1_position_tumb(_("Green Recognition Light Key/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_28,109,-1,{-1,0})

elements["pnt_110"]	= default_3_position_tumb(_("Amber Recognition Light Key/Off/Steady") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_23,110,false, true)
elements["pnt_110_0"] = default_1_position_tumb(_("Amber Recognition Light Steady/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_29,110,1,{0,1})
elements["pnt_110_1"] = default_1_position_tumb(_("Amber Recognition Light Key/Off") ,devices.RIGHT_SWITCH_PANEL,device_commands.Button_29,110,-1,{-1,0})

elements["pnt_111"] = default_button(_("Recognition Lights Key"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_24,111)
elements["pnt_112"] = default_button(_("Circuit Protectors Reset"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_25,112)

elements["pnt_0"] = default_axis(_("Right Fluorescent Light"),devices.RIGHT_SWITCH_PANEL, device_commands.Button_7, 0, 0.0, 0.1, false, false)
elements["PANEL LIGHT"] = default_1_position_tumb(_("Left Fluorescent Light"),devices.LIGHT_SYSTEM, device_commands.Button_2, 44,1,{0,1})

--Flight Instrument panel
elements["COMPASS_RING"] = default_axis(_("Course Set"),devices.REMOTE_COMPASS, device_commands.Button_1, 74, 1.0, 0.1, false, true)
elements["pnt_13"] = default_button_axis(_("Heading Set/Cage"),devices.DIRECTIONAL_GYRO, device_commands.Button_3, device_commands.Button_1, 179, 0,1.0,1.0)
elements["pnt_13"].relative = {false,true}
elements["pnt_13"].animated  = {false,false}
elements["pnt_13"].gain  = {0,0.02}

elements["Pitch"] = default_axis(_("Pitch Adjustment"),devices.ARTIFICIAL_HORIZON, device_commands.Button_2, 503, 1.0, 0.1, false, false)
elements["CAGE"] = default_button_axis(_("Cage"),devices.ARTIFICIAL_HORIZON, device_commands.Button_1, device_commands.Button_3, 502, 501, 1.0,0.14)

elements["pnt_7"] = { 
	class = {class_type.BTN, class_type.LEV}, 
	hint = _("Winding/Adjustment Clock"), 
	device = devices.CLOCK, 
	action = {device_commands.Button_1, device_commands.Button_2},
	stop_action = {device_commands.Button_1,  0}, 
	is_repeatable = {}, 
	arg = {8, 7}, 
	arg_value = {1.0, 0.04}, 
	arg_lim = {{0, 1},  {0, 1}}, 
	relative = {false,true}, 
	gain = {1.0,  0.1}, 
	use_release_message = {true, false}, 
	use_OBB = true 
}

elements["ALT_MBAR"] = default_axis(_("Set Pressure"),devices.ALTIMETER, device_commands.Button_1, 30, 1.0, 0.4, false, true)

--SCR-522A Control panel 
function radio_channel_button(hint_,device_,command_,arg_)
	return  {	
				class 				= {class_type.BTN},
				hint  				= hint_,
				device 				= device_,
				action 				= {command_},
				arg 				= {arg_},
				arg_value			= {1}, 
				arg_lim 			= {{0,1}},
				use_release_message = {true},
				sound 				= {{SOUND_RADIO_BTN}}
			}
end

elements["RCTRL_OFF"] = radio_channel_button(_("Radio ON/OFF"),devices.VHF_RADIO, device_commands.Button_1,515)
elements["RCTRL_A"] = radio_channel_button(_("A Channel Activate"),devices.VHF_RADIO, device_commands.Button_2,516)
elements["RCTRL_B"] = radio_channel_button(_("B Channel Activate"),devices.VHF_RADIO, device_commands.Button_3,517)
elements["RCTRL_C"] = radio_channel_button(_("C Channel Activate"),devices.VHF_RADIO, device_commands.Button_4,518)
elements["RCTRL_D"] = radio_channel_button(_("D Channel Activate"),devices.VHF_RADIO, device_commands.Button_5,519)

elements["RCTRL_DIM"] = default_axis(_("Radio Lights Dimmer"),devices.VHF_RADIO, device_commands.Button_6, 125, 1.0, 0.2, true, false)
elements["pnt_0"] = default_axis(_("Radio Audio Volume "),devices.VHF_RADIO, device_commands.Button_15, 0, 1.0, 0.1, false, false)

elements["BUTTON_BOMB"]	= default_button(_("Microphone On"),devices.CPT_MECH,device_commands.Button_1,128)
elements["BUTTON_BOMB"].updatable = true

elements["pnt_200"] = default_2_position_tumb(_("Arm rest"),devices.CPT_MECH, device_commands.Button_9, 200)
elements["pnt_200"].animated = {true}
elements["pnt_200"].animation_speed = {4}

elements["RCTRL_TLOCK"] = default_2_position_tumb(_("Switch Locking Lever"),devices.VHF_RADIO, device_commands.Button_17, 155)

elements["pnt_128_-1"] = default_button(_("Radio Mode Transmit") ,devices.VHF_RADIO,device_commands.Button_20,156,-1,{-1.0,0.0})
elements["pnt_128_0"] = default_1_position_tumb(_("Radio Mode Receive") ,devices.VHF_RADIO,device_commands.Button_21,156,0.0,{0.0,0.0})
elements["pnt_128_1"] = default_1_position_tumb(_("Radio Mode Remote") ,devices.VHF_RADIO,device_commands.Button_21,156,1.0,{1.0,1.0})

elements["RCTRL_T"] = default_button_tumb(_("Radio Mode"),devices.VHF_RADIO, device_commands.Button_8, device_commands.Button_7, 156)

--Front Switch Box
elements["PITLITE_LH"] 		= default_1_position_tumb(_("Cockpit Lights"),devices.FRONT_SWITCH_BOX, device_commands.Button_1, 60, 1,{0,1})

elements["MAGNETO0"] 	= default_1_position_tumb(_("Ignition Off"), devices.FRONT_SWITCH_BOX, device_commands.Button_5, 56, 0, {0,0})
elements["MAGNETO0"] 	= default_1_position_tumb(_("Ignition Right"), devices.FRONT_SWITCH_BOX, device_commands.Button_5, 56, 0, {0.1,0.1})
elements["MAGNETO0"] 	= default_1_position_tumb(_("Ignition Left"), devices.FRONT_SWITCH_BOX, device_commands.Button_5, 56, 0, {0.2,0.2})
elements["MAGNETO0"] 	= default_1_position_tumb(_("Ignition Both"), devices.FRONT_SWITCH_BOX, device_commands.Button_5, 56, 0, {0.3,0.3})
elements["MAGNETO0"]	= default_1_position_tumb(_("Ignition"), devices.FRONT_SWITCH_BOX, device_commands.Button_2, 56, 4, 0.1,true)

--elements["MAGNETO0"]	= multiposition_switch_limited(_("Ignition"), devices.FRONT_SWITCH_BOX, device_commands.Button_2, 56, 4, 0.1,true)

elements["GUNSIGHT_SWITCH"]	= default_2_position_tumb(_("Gun control") ,devices.FRONT_SWITCH_BOX,device_commands.Button_7,80)
--elements["GUNSIGHT_SWITCH"]	= default_1_position_tumb(_("Gun And Camera On") ,devices.FRONT_SWITCH_BOX,device_commands.Button_12,80,1,{1,1})
--elements["GUNSIGHT_SWITCH"]	= default_1_position_tumb(_("Gun And Camera Off") ,devices.FRONT_SWITCH_BOX,device_commands.Button_12,80,0,{0,0})
--elements["GUNSIGHT_SWITCH"]	= default_1_position_tumb(_("Camera On") ,devices.FRONT_SWITCH_BOX,device_commands.Button_12,80,-1,{-1,-1})

elements["pnt_72"]		= default_button(_("Silence Landing Gear Warning Horn Cut Off"),devices.FRONT_SWITCH_BOX,device_commands.Button_8,72)

elements["STARTER_COVER"] = default_1_position_tumb(_("Left Chemical Release"),devices.FRONT_SWITCH_BOX, device_commands.Button_13,64, 1, {1,1})
elements["STARTER_COVER"] = default_1_position_tumb(_("Left Bomb Arm Off"),devices.FRONT_SWITCH_BOX, device_commands.Button_13, 64,0, {0,0})
elements["STARTER_COVER"] = default_1_position_tumb(_("Left Bomb Arm On"),devices.FRONT_SWITCH_BOX, device_commands.Button_13, 64,-1, {-1,-1})
elements["STARTER_COVER"]	= default_3_position_tumb(_("Left Bomb Arm/Chemical") ,devices.FRONT_SWITCH_BOX,device_commands.Button_9,64,-1, {-1,-1})

elements["BOOSTER_COVER_1"] = default_1_position_tumb(_("Right Chemical Release"),devices.FRONT_SWITCH_BOX, device_commands.Button_14,66, 1, {1,1})
elements["BOOSTER_COVER"] = default_1_position_tumb(_("Right Bomb Arm Off"),devices.FRONT_SWITCH_BOX, device_commands.Button_14,66, 0, {0,0})
elements["BOOSTER_COVER"] = default_1_position_tumb(_("Right Bomb Arm On"),devices.FRONT_SWITCH_BOX, device_commands.Button_14,66, -1, {-1,-1})
elements["BOOSTER_COVER"]	= default_3_position_tumb(_("Right Bomb Arm/Chemical") ,devices.FRONT_SWITCH_BOX,device_commands.Button_10,66,-1, {-1,-1})

elements["TANK_PRS_0"] = default_1_position_tumb(_("Bombs and Rockets Safe"),devices.FRONT_SWITCH_BOX, device_commands.Button_15, 70, 0, {0,0})
elements["TANK_PRS_1"] = default_1_position_tumb(_("Bombs Train Release"),devices.FRONT_SWITCH_BOX, device_commands.Button_15, 70, 0.1, {0.1,0.1})
elements["TANK_PRS_2"] = default_1_position_tumb(_("Bombs Both Release"),devices.FRONT_SWITCH_BOX, device_commands.Button_15, 70, 0.2, {0.2,0.2})
elements["TANK_PRS_3"] = default_1_position_tumb(_("Rockets Arm"),devices.FRONT_SWITCH_BOX, device_commands.Button_15, 70, 0.3, {0.3,0.3})
elements["TANK_PRS"]	= multiposition_switch(_("Release Mode"), devices.FRONT_SWITCH_BOX, device_commands.Button_11, 70, 4, 0.1)

elements["PITLITE_RH_0"] = default_1_position_tumb(_("Rockets Release Off"),devices.WEAPON_CONTROL, device_commands.Button_7, 61, 0.0, {0,0})
elements["PITLITE_RH_1"] = default_1_position_tumb(_("Rockets Release Single"),devices.WEAPON_CONTROL, device_commands.Button_7, 61, 0.1, {0.1,0.1})
elements["PITLITE_RH_2"] = default_1_position_tumb(_("Rockets Release Auto"),devices.WEAPON_CONTROL, device_commands.Button_7, 61, 0.2, {0.2,0.2})
elements["PITLITE_RH"]	= multiposition_switch(_("Rockets Release Mode"), devices.WEAPON_CONTROL, device_commands.Button_13, 61, 3,0.1,true)

elements["pnt_74"] = default_2_position_tumb(_("Rockets Delay Switch"),devices.WEAPON_CONTROL, device_commands.Button_8,74)
elements["pnt_74_0"] = default_1_position_tumb(_("Rockets Delay"),devices.WEAPON_CONTROL, device_commands.Button_14, 74, 1, {1,1})
elements["pnt_74_1"] = default_1_position_tumb(_("Rockets Int"),devices.WEAPON_CONTROL, device_commands.Button_14, 74, 0, {0,0})

elements["pnt_76"] =  {
			 class  		 = {class_type.TUMB,class_type.TUMB}, 
			 hint   		 = _("Rockets Counter Control"),
			 device 		 = devices.WEAPON_CONTROL,
			 action 		 = {device_commands.Button_9 ,device_commands.Button_10}, 
			 arg 			 = {75,75},
			 arg_value 		 = { -1/11, 1/11},
			 arg_lim   		 = {{0,1},{0,1}},
			 relative		 = {true,true},
			 animated        = {true,true},
			 cycle			 = true,
			 animation_speed = {0.5, 0.5}
			}

--Gunsight Selector
elements["pnt_41_1"] = default_1_position_tumb(_("Sight On"),devices.K14_GUNSIGHT, device_commands.Button_15,41,1,{1,1})
elements["pnt_41_0"] = default_1_position_tumb(_("Sight Off"),devices.K14_GUNSIGHT, device_commands.Button_15,41,0,{0,0})
elements["pnt_41"] = default_2_position_tumb(_("Sight On/Off"),devices.K14_GUNSIGHT, device_commands.Button_4,41)

elements["pnt_39"] = default_2_position_tumb(_("Fixed Reticle Mask Lever"),devices.K14_GUNSIGHT, device_commands.Button_6,39)
elements["pnt_40_0"] = default_1_position_tumb(_("Fixed Sight"), devices.K14_GUNSIGHT, device_commands.Button_16, 40, 0, {0,0})
elements["pnt_40_1"] = default_1_position_tumb(_("Fixed-Gyro Sight"), devices.K14_GUNSIGHT, device_commands.Button_16, 40, 0.1, {0.1,0.1})
elements["pnt_40_2"] = default_1_position_tumb(_("Gyro Sight"), devices.K14_GUNSIGHT, device_commands.Button_16, 40, 0.2, {0.2,0.2})
elements["pnt_40"]	= multiposition_switch(_("Sight Mode"), devices.K14_GUNSIGHT, device_commands.Button_3, 40, 3, 0.1)

elements["GUNSIGHT_DIMMER"] = default_axis(_("Gun Sight Brightness"),devices.K14_GUNSIGHT, device_commands.Button_5, 81, 1.0, 0.1, false, false)
elements["pnt_0"] = default_movable_axis(_("Wing Span Selector"),devices.K14_GUNSIGHT, device_commands.Button_1, 0, 0.0, -0.1, true, false)

--Engine Control Panel
elements["pnt_58"] = default_2_position_tumb(_("Supercharger Switch Cover"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_2,0)
elements["pnt_57_0"] = default_1_position_tumb(_("Supercharger AUTO"), devices.ENGINE_CONTROL_PANEL, device_commands.Button_1, 0, 0, {0,0})
elements["pnt_57_1"] = default_1_position_tumb(_("Supercharger LOW"), devices.ENGINE_CONTROL_PANEL, device_commands.Button_1, 0, 0.1, {0.1,0.1})
elements["pnt_57_2"] = default_button(_("Supercharger HIGH"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_1,0,0.2,{0.1,0.2})

elements["pnt_60"]	= default_button(_("High Blower Lamp Test "),devices.ENGINE_CONTROL_PANEL,device_commands.Button_4,0)                   -----------------

elements["WOBBLE_PUMP_1"] = default_1_position_tumb(_("Fuel Booster On"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_12,90,1,{1,1})
elements["WOBBLE_PUMP_0"] = default_1_position_tumb(_("Fuel Booster Off"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_12,90,0,{0,0})
elements["WOBBLE_PUMP"] = default_2_position_tumb(_("Fuel Booster On/Off"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_5,90)

elements["pnt_62_1"] = default_button(_("Oil Dilute Activate"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_7,62)
elements["pnt_62"] = default_button(_("Oil Dilute Activate"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_13,62)

elements["Starter"] = default_button(_("Starter Activate"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_8,500)
elements["pnt_0"] = default_2_position_tumb(_("Starter Switch Cover"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_9,0)

elements["BLOWER_1"] = default_button(_("Primer Activate"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_14,58)
elements["BLOWER"] = default_button(_("Primer Activate"),devices.ENGINE_CONTROL_PANEL, device_commands.Button_11,58)

--Oxygen Regulator

elements["OXY_VALVE"] = default_2_position_tumb(_("Auto-Mix On-Off"),devices.OXYGEN_SYSTEM, device_commands.Button_3, 13)	
elements["pnt_131"] = default_animated_lever(_("Oxygen Emergency By-pass"),devices.OXYGEN_SYSTEM, device_commands.Button_1, 131,0.6,{0, 0.5},0.5)					 

--Fuel system
elements["DROPTANK_COCK_4"] = default_1_position_tumb(_("Select Right Combat Tank"), devices.FUEL_SYSTEM, device_commands.Button_4, 98, 0.0, {0.0,0.0})
elements["DROPTANK_COCK_1"] = default_1_position_tumb(_("Select Left Main Tank"), devices.FUEL_SYSTEM, device_commands.Button_4, 98, 0.1, {0.1,0.1})
elements["DROPTANK_COCK_2"] = default_1_position_tumb(_("Select Fuselage Tank"), devices.FUEL_SYSTEM, device_commands.Button_4, 98, 0.2, {0.2,0.2})
elements["DROPTANK_COCK_3"] = default_1_position_tumb(_("Select Right Main Tank"), devices.FUEL_SYSTEM, device_commands.Button_4, 98, 0.3, {0.3,0.3})
elements["DROPTANK_COCK_0"] = default_1_position_tumb(_("Select Left Combat Tank"), devices.FUEL_SYSTEM, device_commands.Button_4, 98, 0.4, {0.4,0.4})
elements["DROPTANK_COCK"]	= multiposition_switch(_("Fuel Selector Valve"), devices.FUEL_SYSTEM, device_commands.Button_1, 98, 5, 0.1,true)

elements["FUEL_COCK"] = default_animated_lever(_("Fuel Shut-Off Valve"),devices.FUEL_SYSTEM, device_commands.Button_2,100,3.5)	
elements["FUEL_COCK"].sound = {{SOUND_FUEL_SHUTOFF_ON},{SOUND_FUEL_SHUTOFF_OFF}}

elements["FUEL_COCK_1"] = default_1_position_tumb(_("Fuel Shut-Off Valve On"),devices.FUEL_SYSTEM, device_commands.Button_5,100,1,{1,1})
elements["FUEL_COCK_0"] = default_1_position_tumb(_("Fuel Shut-Off Valve Off"),devices.FUEL_SYSTEM, device_commands.Button_5,100,0,{0,0})
							
--AN/APS-13
elements["pnt_114"] = default_2_position_tumb(_("Tail Warning Radar Power"),devices.TAIL_WARNING_RADAR, device_commands.Button_1,0)
elements["pnt_114_1"] = default_1_position_tumb(_("Tail Warning Radar Power On"),devices.TAIL_WARNING_RADAR, device_commands.Button_7,0,1,{1,1})
elements["pnt_114_0"] = default_1_position_tumb(_("Tail Warning Radar Power Off"),devices.TAIL_WARNING_RADAR, device_commands.Button_7,0,0,{0,0})
elements["pnt_115"]	= default_button(_("Tail Warning Radar Test"),devices.TAIL_WARNING_RADAR,device_commands.Button_3,115)
elements["pnt_115_1"] = default_button(_("Tail Warning Radar Test"),devices.TAIL_WARNING_RADAR,device_commands.Button_8,115)
elements["pnt_113"] = default_axis(_("Tail Warning Radar Light Control"),devices.TAIL_WARNING_RADAR, device_commands.Button_4, 113, 1.0, 0.1, false, false)

-------------
elements["pnt_79"] = default_animated_lever(_("Hydraulic Release Knob"),devices.HYDRAULIC_SYSTEM, device_commands.Button_1,79,5.0)	

elements["FLAPS"] = default_movable_axis(_("Flaps Control Handle"),devices.CONTROL_SYSTEM, device_commands.Button_1,47, 0.0, 0.1, true, false)
						
elements["UC"] = default_2_position_tumb(_("Landing Gear Control Handle"),devices.CONTROL_SYSTEM, device_commands.Button_3,95)
elements["UC"] = default_2_position_tumb(_("Landing Gear Control Handle"),devices.CONTROL_SYSTEM, device_commands.Button_3,95)


elements["pnt_84"] = default_button(_("Parking Brake Handle"),devices.CONTROL_SYSTEM, device_commands.Button_5,84)				
elements["pnt_84"].use_release_message = true

elements["pnt_81"]	= default_button(_("Safe Landing Gear Light Test"),devices.CONTROL_SYSTEM,device_commands.Button_18,81)
elements["pnt_83"]	= default_button(_("Unsafe Landing Gear Light Test"),devices.CONTROL_SYSTEM,device_commands.Button_7,83)

--Detrola receiver
elements["pnt_137"] = default_axis(_("Detrola Frequency Selector"),devices.DETROLA, device_commands.Button_1, 137, 0.0, 0.1, true, false)
--elements["pnt_138"] = default_axis(_("Detrola Volume"),devices.DETROLA, device_commands.Button_2, 138, 0.0, 0.1, true, false)

--canopy
elements["pnt_149"] = default_movable_axis(_("Canopy Hand Crank"),devices.CPT_MECH, device_commands.Button_2, 149, 0.0, -0.4, true, true) 
elements["pnt_140"] = default_2_position_tumb(_("Canopy Emergency Release Handle"),devices.CPT_MECH, device_commands.Button_3,139) 
elements["HATCH_JETTISON"] = default_axis(_("Canopy Hand Crank"),devices.CPT_MECH, device_commands.Button_8, 140, 0.0, -4.0, true, true)

--AN/ARA-8
elements["pnt_152_0"] = default_1_position_tumb(_("Homing Adapter TRANSMIT"), devices.HOMING_ADAPTER, device_commands.Button_5, 152, 0.0, {0.0,0.0})
elements["pnt_152_1"] = default_1_position_tumb(_("Homing Adapter COMM."), devices.HOMING_ADAPTER, device_commands.Button_5, 152, 0.1, {0.1,0.1})
elements["pnt_152_2"] = default_1_position_tumb(_("Homing Adapter HOMING"), devices.HOMING_ADAPTER , device_commands.Button_5, 152, 0.2, {0.2,0.2})
elements["pnt_152"]	= multiposition_switch_limited(_("Homing Adapter Mode") ,devices.HOMING_ADAPTER ,device_commands.Button_1,152,3,0.1)

elements["pnt_154"]	= default_button(_("Homing Adapter's Circuit Breaker"),devices.HOMING_ADAPTER,device_commands.Button_3,0)
elements["pnt_153"] = default_2_position_tumb(_("Homing Adapter On/Off"),devices.HOMING_ADAPTER, device_commands.Button_2,153)
elements["pnt_153_1"] = default_1_position_tumb(_("Homing Adapter Power On"), devices.HOMING_ADAPTER, device_commands.Button_6, 153, 1, {1,1})
elements["pnt_153_0"] = default_1_position_tumb(_("Homing Adapter Power Off"), devices.HOMING_ADAPTER, device_commands.Button_6, 153, 0.0, {0.0,0.0})
--SCR-695
elements["pnt_0"] = default_2_position_tumb(_("IFF Power On/Off"),devices.IFF, device_commands.Button_1,0)
elements["pnt_0_1"] = default_1_position_tumb(_("IFF Power On"), devices.IFF, device_commands.Button_14, 0, 1, {1,1})
elements["pnt_0_0"] = default_1_position_tumb(_("IFF Power Off"), devices.IFF, device_commands.Button_14, 0, 0.0, {0.0,0.0})

elements["pnt_143"] = default_2_position_tumb(_("IFF Distress Signal"),devices.IFF, device_commands.Button_5,143)
elements["pnt_143_1"] = default_1_position_tumb(_("IFF Distress Signal On"), devices.IFF, device_commands.Button_15, 143, 1, {1,1})
elements["pnt_143_0"] = default_1_position_tumb(_("IFF Distress Signal Off"), devices.IFF, device_commands.Button_15, 143, 0.0, {0.0,0.0})

elements["pnt_142"]	= default_2_position_tumb(_("IFF Detonator Circuit On/Off"),devices.IFF,device_commands.Button_4,142)
elements["pnt_145"]	= default_button(_("IFF Detonator Left"),devices.IFF,device_commands.Button_7,0)
elements["pnt_146"]	= default_button(_("IFF Detonator Right"),devices.IFF,device_commands.Button_8,0)

elements["pnt_141_-1"] = default_1_position_tumb(_("IFF TIME"), devices.IFF, device_commands.Button_17, 141, -1, {-1.0,-1.0})
elements["pnt_141_0"] = default_1_position_tumb(_("IFF OFF"), devices.IFF, device_commands.Button_17, 141, 0, {0.0,0.0})
elements["pnt_141_1"] = default_1_position_tumb(_("IFF ON"), devices.IFF, device_commands.Button_17, 141, 1, {1.0,1.0})
elements["pnt_141"]	= default_3_position_tumb(_("IFF TIME/OFF/ON") ,devices.IFF,device_commands.Button_3,141,false,false)

elements["pnt_139_1"] = default_1_position_tumb(_("IFF CODE 1"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.0,0.0})
elements["pnt_139_2"] = default_1_position_tumb(_("IFF CODE 2"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.1,0.1})
elements["pnt_139_3"] = default_1_position_tumb(_("IFF CODE 3"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.2,0.2})
elements["pnt_139_4"] = default_1_position_tumb(_("IFF CODE 4"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.3,0.3})
elements["pnt_139_5"] = default_1_position_tumb(_("IFF CODE 5"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.4,0.4})
elements["pnt_139_6"] = default_1_position_tumb(_("IFF CODE 6"), devices.IFF, device_commands.Button_16, 139, 0.0, {0.5,0.5})
elements["pnt_139"]	= multiposition_switch_limited(_("IFF Code Selector"), devices.IFF, device_commands.Button_2, 139, 6, 0.1)

--Trimmers
elements["RTRIM_WHEEL"] = default_axis_limited(_("Aileron Trim"),devices.CONTROL_SYSTEM, device_commands.Button_8, 154, 0.0, 0.1/5.0, false, true,{-1,1})
elements["TRIM_WHEEL"] = default_axis_limited(_("Elevator Trim"),devices.CONTROL_SYSTEM, device_commands.Button_9, 114, 0.0, 0.1/10.0, false, true,{-1,1})
elements["pnt_91"] = default_axis_limited(_("Rudder Trim"),devices.CONTROL_SYSTEM, device_commands.Button_10, 91, 0.0, 0.1/5.0, false, true,{-1,1})

elements["pnt_132"] = default_animated_lever(_("Left Payload Salvo"),devices.WEAPON_CONTROL, device_commands.Button_3,132,4.0)
elements["pnt_133"] = default_animated_lever(_("Right Payload Salvo"),devices.WEAPON_CONTROL, device_commands.Button_4,133,3.0)

elements["pnt_157"] = default_axis(_("Defroster"),devices.ENVIRONMENT_SYSTEM, device_commands.Button_1, 157, 0.0, 0.1, true, false)
elements["pnt_158"] = default_axis(_("Cold Air"),devices.ENVIRONMENT_SYSTEM, device_commands.Button_2, 158, 0.0, 0.1, true, false)
elements["pnt_159"] = default_axis(_("Hot Air"),devices.ENVIRONMENT_SYSTEM, device_commands.Button_3, 159, 0.0, 0.1, true, false)

elements["pnt_89"] = default_2_position_tumb(_("Landing Light On/Off"),devices.LIGHT_SYSTEM, device_commands.Button_3,89)
elements["pnt_89_1"] = default_1_position_tumb(_("Landing Light On"),devices.LIGHT_SYSTEM, device_commands.Button_7,89,1,{1,1})
elements["pnt_89_0"] = default_1_position_tumb(_("Landing Light Off"),devices.LIGHT_SYSTEM, device_commands.Button_7,89,0,{0,0})

elements["pnt_168"] = default_2_position_tumb(_("Coolant Control Cover"),devices.ENGINE_SYSTEM, device_commands.Button_3,168)
elements["pnt_87_0"] = default_button(_("Close Coolant Control"),devices.ENGINE_SYSTEM, device_commands.Button_1,87,0.1,{0.0,0.1})
elements["pnt_87_1"] = default_1_position_tumb(_("Automatic Coolant Control"),devices.ENGINE_SYSTEM, device_commands.Button_1, 87, 0.2, {0.0,0.2})
elements["pnt_87_2"] = default_button(_("Open Coolant Control"),devices.ENGINE_SYSTEM, device_commands.Button_1, 87, 0.3, {0.0,0.3})

elements["pnt_169"] = default_2_position_tumb(_("Oil Control Cover"),devices.ENGINE_SYSTEM, device_commands.Button_4,169)
elements["pnt_88_0"] = default_button(_("Close Oil Control"),devices.ENGINE_SYSTEM, device_commands.Button_2, 88, 0.1, {0.0,0.1})
elements["pnt_88_1"] = default_1_position_tumb(_("Automatic Oil Control"),devices.ENGINE_SYSTEM, device_commands.Button_2, 88, 0.2, {0.0,0.2})
elements["pnt_88_2"] = default_button(_("Open Oil Control"),devices.ENGINE_SYSTEM, device_commands.Button_2, 88, 0.3, {0.0,0.3})

elements["CARB_AIR"] = default_movable_axis(_("Carburetor Cold Air Control"),devices.ENGINE_SYSTEM, device_commands.Button_7, 137, 0.0, 0.1, true, false)
elements["RADIATOR"] = default_movable_axis(_("Carburetor Warm Air Control"),devices.ENGINE_SYSTEM, device_commands.Button_27, 133, 0.0, 0.1, true, false)

elements["MIX"]	= multiposition_switch(_("Mixture Control Select IDLE CUT OFF/RUN/EMERGENCY FULL RICH"), devices.ENGINE_SYSTEM, device_commands.Button_11, 130, 3, 0.1)
elements["MIX_01"] = default_1_position_tumb(_("Mixture IDLE"), devices.ENGINE_SYSTEM, device_commands.Button_19, 130, 0.0, {0.0,0.0})
elements["MIX_02"] = default_1_position_tumb(_("Mixture RUN"), devices.ENGINE_SYSTEM, device_commands.Button_19, 130, 0.0, {0.1,0.1})
elements["MIX_03"] = default_1_position_tumb(_("Mixture EMERGENCY FULL RICH"), devices.ENGINE_SYSTEM, device_commands.Button_19, 130, 0.0, {0.2,0.2})

elements["THTL"] = default_movable_axis(_("Throttle"),devices.ENGINE_SYSTEM, device_commands.Button_21, 126, 0.0, 0.2, true, false)
elements["PROP"] = default_movable_axis(_("Propeller RPM"),devices.ENGINE_SYSTEM, device_commands.Button_22, 129, 0.0, 0.2, true, false)

elements["pnt_173"] =  {	
				class 		= {class_type.BTN,class_type.BTN},
				hint  		= _("Surface Control Lock Plunger. Left Button - Lock Stick in the Forward Position', Right Button - Lock Stick in the Neutral Position"),
				device 		= devices.CONTROL_SYSTEM,
				action 		= {device_commands.Button_15,device_commands.Button_16},
				stop_action = {device_commands.Button_15,device_commands.Button_16},
				arg 	  	= {173,173},
				arg_value 	= {1.0,1.0}, 
				arg_lim   	= {{0,1},{0,1}},
				updatable 	= true, 
				use_OBB 	= true,
				sound       = {{},{}},
				use_release_message = {true,true}
			}

elements["pnt_48"] = default_axis(_("Lock Throttle"),devices.ENGINE_SYSTEM, device_commands.Button_12,48, 0.0, 0.1, true, false)
elements["pnt_49"] = default_axis(_("Lock Propeller & Mixture"),devices.ENGINE_SYSTEM, device_commands.Button_14,49, 0.0, 0.1, true, false)					
	
elements["pnt_176"] = default_button(_("G-meter reset"),devices.ACCELEROMETER, device_commands.Button_1, 176, 0.6, {0.0,0.6})
	
elements["GUNSIGHT_TINT"] = {class  = {class_type.TUMB,class_type.TUMB},
					   hint   = _("GUNSIGHT_TINT"), 
					   device 		= 0,
					   action		= {device_commands.Button_1, device_commands.Button_1},
					   arg	  		= {79, 79},
					   arg_value 	= {1, 0},
					   arg_lim   	= {{0,1},{0,1}},
					   updatable  = true, 
					   cycle	  = true}

					   ------------------------------------------------------------------					 
for i,o in pairs(elements) do
	if  o.class[1] == class_type.TUMB or 
	   (o.class[2]  and o.class[2] == class_type.TUMB) or
	   (o.class[3]  and o.class[3] == class_type.TUMB)  then
	   o.updatable = true
	   o.use_OBB   = true
	end
end


